#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec2 Rotate(vec2 p, float a ) 
{
	vec2 t = cos(a) * p + sin(a) * (vec2)( p.y, -p.x);
    return t;
}

float circle( vec2 p, float r )
{
    return ( length( p / r ) - 1.0f ) * r;
}

float random( vec2 c )
{
    float itpr = 0.0f;
	return fract(sin( dot( c.xy, (vec2)( 12.9898f, 78.233f))) * 43758.5453f,&itpr);
}

vec3 Bokeh( vec3 color, vec2 p, vec3 c )   
{
    float wrap = 450.0f;    
    if ( fmod( floor( p.y / wrap + 0.5f), 2.0f) == 0.0f )
    {
        p.x += wrap * 0.5f;
    }    
    
    vec2 p2 = fmod( p + 0.5f * wrap, wrap) - 0.5f * wrap;
    vec2 cell = floor( p / wrap + 0.5f );
    float cellR = random( cell);
        
    float itpr = 0.0f;
    c *= fract( cellR * 3.33f + 3.33f,&itpr);    
    float radius = mix( 30.0f, 70.0f, fract( cellR * 7.77 + 7.77,&itpr));
    p2.x *= mix( 0.9f, 1.1f, fract( cellR * 11.13f + 11.13f,&itpr));
    p2.y *= mix( 0.9f, 1.1f, fract( cellR * 17.17f + 17.17f,&itpr));
    
    float cir = circle( p2, radius );
    float circle = 1.0f - smoothstep( 0.0f, 1.0f, cir );
    float glow	 = exp( -cir * 0.025f ) * 0.3f * ( 1.0f - circle );
    vec3 tmpColor = color + c * ( circle + glow );
    return tmpColor;
}

__kernel void MAIN(
      __read_only image2d_t input,    
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha) 
{
    int W = get_global_size(0);
	int H = get_global_size(1);
    float2 resolution = (float2)(W,H);  
    int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));

    vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((float2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;

    vec2 uv = (float2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);

    float4 orig = read_imagef(input, sampler, uv);     
    
    float fragX = (float)(get_global_id(0) - get_global_offset(0));
    float fragY = (float)(get_global_id(1) - get_global_offset(1));
    vec2 frag = (vec2)(fragX,fragY);
	
    float time = param->cur_time * 2.0f;

    vec2 p = ( 2.0f * frag - resolution.xy ) / resolution.x * 1000.0f;
    
	vec3 color = mix( (vec3)( 0.3f, 0.1f, 0.3f), (vec3)( 0.1f, 0.4f, 0.5f), dot( uv, (vec2)( 0.2f, 0.7f) ) );      
    vec2 rp = Rotate( p, 0.2f + time * 0.03f);
    vec3 tColor = Bokeh( color, rp + (vec2)( -50.0f * time +  0.0f, 0.0f ), 3.0f * (vec3)( 0.4f, 0.1f, 0.2f) );
	rp = Rotate( rp, 0.3f - time * 0.05f );
    tColor = Bokeh( tColor, rp + (vec2)( -70.0f * time + 33.0f, -33.0f ), 3.5f * (vec3)( 0.6f, 0.4f, 0.2f ) );
	rp = Rotate( rp, 0.5f + time * 0.07f );
    tColor = Bokeh( tColor, rp + (vec2)( -60.0f * time + 55.0f, 55.0f ), 3.0f * (vec3)( 0.4f, 0.3f, 0.2f ) );
    rp = Rotate( rp, 0.9f - time * 0.03f );
    tColor = Bokeh( tColor, rp + (vec2)( -25.0f * time + 77.0f, 77.0f ), 3.0f * (vec3)( 0.4f, 0.2f, 0.1f ) );    
    rp = Rotate( rp, 0.0f + time * 0.05f );
    tColor = Bokeh( tColor, rp + (vec2)( -15.0f * time + 99.0f, 99.0f ), 3.0f * (vec3)( 0.2f, 0.0f, 0.4f ) );     

	vec4 fragColor = (vec4)( tColor.zyx, orig.w);
    fragColor.xyz = 1.0f - (1.0f - orig.xyz)*(1.0f-fragColor.xyz);
    
    vec4 retColor =  mix( fragColor, orig, 1.0f - (float)(alpha)/100.0f ); 
    write_imagef(dest_data,gl_FragCoord,retColor);
}



